import '@testing-library/jest-dom';
import { cleanup } from '@testing-library/react';

// Mock node-fetch
const { default: fetch, Request, Response } = require('node-fetch');

// Mock TextEncoder/TextDecoder
class MockTextEncoder {
  encode(text: string): Uint8Array {
    return new Uint8Array(Buffer.from(text));
  }
}

class MockTextDecoder {
  decode(buffer: Uint8Array): string {
    return Buffer.from(buffer).toString();
  }
}

global.TextEncoder = MockTextEncoder as any;
global.TextDecoder = MockTextDecoder as any;

if (!globalThis.fetch) {
  // @ts-ignore
  globalThis.fetch = fetch;
  // @ts-ignore
  globalThis.Request = Request;
  // @ts-ignore
  globalThis.Response = Response;
}

// React testing setup
afterEach(() => {
  cleanup();
});
function afterEach(arg0: () => void) {
  throw new Error('Function not implemented.');
}

