export interface User {
  id: number;
  name: string;
  email: string;
  role: string;
  credits: number;
}

export interface Template {
    id: number;
    user_id: number;
    name: string;
    subject: string;
    body: string;
    // --- SUGGESTION: Standardized to camelCase for consistency ---
    createdAt: string;
    lastModified: string;
}

export interface SequenceStep {
  id: string;
  name: string;
  description?: string;
  delay: number;
  condition: 'none' | 'not-opened' | 'not-clicked' | 'opened-no-click';
  templateId: number | null;
  subject: string;
  body: string;
}

export interface Campaign {
  id: number;
  user_id: number;
  name: string;
  objective: CampaignObjective | '';
  status: 'Draft' | 'Scheduled' | 'Sending' | 'Sent' | 'Failed' | 'Archived';
  audienceListId: number;
  trackingDomainId?: number;

  sequence: {
    steps: SequenceStep[];
  };

  sender: {
    warmup: boolean;
    throttling: boolean;
  };

  // --- SUGGESTION: Added optional properties to reflect joined data ---
  // This makes the type more "honest" about the data shape the UI components will receive from server actions.
  audience?: AudienceList;
  audience_name?: string; // For list views where we only join the name
  senderIds?: number[];

  createdAt: string;
  lastModified: string;
}

// --- SUGGESTION: This type is no longer used by the main Campaign interface and can be removed for clarity ---
// export type SenderInfra = 'Gmail' | 'Custom SMTP' | 'EP Infra';

export type CampaignObjective = 'Lead Nurturing' | 'Sales Conversion' | 'Engagement/Retention' | 'Brand Awareness';
export type AudienceListStatus = 'Draft' | 'Saved';

export interface AudienceList {
    id: number;
    name: string;
    status: AudienceListStatus;
    source: 'Manual' | 'Import' | 'EP DB' | 'One-Off';
    criteria: AudienceCriterion[];
    prospects?: Prospect[];
    count: number;
    // --- SUGGESTION: Standardized to camelCase for consistency ---
    createdAt: string;
    lastModified: string;
}
export interface AudienceCriterion {
    id: string;
    type: 'Industry' | 'Job Title';
    value: string;
}
export interface Prospect {
    // --- SUGGESTION: Changed from string to number to match the database schema (SERIAL PRIMARY KEY) ---
    id: number;
    name: string;
    email: string;
}

