import { cn } from "@/lib/utils";
import type { ReactNode } from "react";

export function PageHeader({ title, description, children, className }: { title: string, description?: string, children?: ReactNode, className?: string }) {
    return (
        <div className={cn("flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8", className)}>
            <div>
                <h1 className="text-3xl font-bold font-headline tracking-tight">{title}</h1>
                {description && <p className="text-muted-foreground mt-1">{description}</p>}
            </div>
            {children && <div className="flex-shrink-0">{children}</div>}
        </div>
    )
}
