
'use client';

import Link from "next/link"
import React from "react";

import { Button } from "@/components/ui/button"
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card"
import { Input } from "@/components/ui/input"
import { Label } from "@/components/ui/label"
import { Logo } from "@/components/logo";
import { useToast } from "@/hooks/use-toast";
import { useRouter } from "next/navigation";
import { signup } from "./actions";
import { UserProvider } from "@/context/UserContext";
import { AnimatedText } from "@/components/auth/animated-text";
import { ActivityLogProvider } from "@/context/ActivityLogContext";


function SignupPageContent() {
    const { toast } = useToast();
    const router = useRouter();

    const handleSignup = async (e: React.FormEvent<HTMLFormElement>) => {
        e.preventDefault();
        const formData = new FormData(e.currentTarget);
        const result = await signup(formData);

        if (result?.error) {
            toast({ variant: 'destructive', title: 'Signup Failed', description: result.error });
        } else {
            toast({ title: 'Signup Successful', description: 'Your account has been created. Please log in.' });
            router.push('/login');
        }
    };

    return (
      <div className="w-full lg:grid lg:min-h-screen lg:grid-cols-2">
        <div className="hidden bg-primary lg:flex flex-col items-center justify-between p-8 text-primary-foreground">
            <div className="flex flex-col items-center text-center max-w-md mt-auto">
                <Logo size="large" />
                <AnimatedText />
            </div>
             <div className="mt-auto text-xs text-primary-foreground/70">
              v1.0.0
            </div>
        </div>
        <div className="flex items-center justify-center py-12">
            <div className="mx-auto grid w-[350px] gap-6 border p-6 rounded-lg">
              <div className="grid gap-2 text-center">
                <h1 className="text-3xl font-bold">Create an account</h1>
                <p className="text-balance text-muted-foreground">
                  Enter your information to get started
                </p>
              </div>
              <form onSubmit={handleSignup}>
                <div className="grid gap-4">
                  <div className="grid gap-2">
                    <Label htmlFor="fullName">Full name</Label>
                    <Input id="fullName" name="fullName" placeholder="John Doe" required />
                  </div>
                  <div className="grid gap-2">
                    <Label htmlFor="email">Email</Label>
                    <Input
                      id="email"
                      name="email"
                      type="email"
                      placeholder="m@example.com"
                      required
                    />
                  </div>
                  <div className="grid gap-2">
                    <Label htmlFor="password">Password</Label>
                    <Input id="password" name="password" type="password" required />
                  </div>
                  <Button type="submit" className="w-full">
                    Create an account
                  </Button>
                </div>
              </form>
              <div className="mt-4 text-center text-sm">
                Already have an account?{" "}
                <Link href="/login" className="underline">
                  Login
                </Link>
              </div>
            </div>
        </div>
      </div>
    );
}

export default function SignupPage() {
    return (
        <UserProvider>
            <ActivityLogProvider>
                <SignupPageContent />
            </ActivityLogProvider>
        </UserProvider>
    )
}
