
'use client';

import { useState } from 'react';
import Link from 'next/link';
import { Button } from '@/components/ui/button';
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { Logo } from '@/components/logo';
import { useToast } from '@/hooks/use-toast';
import { sendResetLink } from './actions';
import { useRouter } from 'next/navigation';
import { AnimatedText } from '@/components/auth/animated-text';

export default function ForgotPasswordPage() {
  const { toast } = useToast();
  const router = useRouter();
  const [email, setEmail] = useState('');
  const [isSubmitting, setIsSubmitting] = useState(false);

  const handleSendLink = async (e: React.FormEvent) => {
    e.preventDefault();
    setIsSubmitting(true);
    const result = await sendResetLink(email);
    if (result.success) {
      toast({
        title: 'Reset Link Sent',
        description: 'If an account with that email exists, a password reset link has been sent.',
      });
      router.push('/login');
    } else {
      toast({
        variant: 'destructive',
        title: 'Error',
        description: result.error,
      });
    }
    setIsSubmitting(false);
  };

  return (
    <div className="w-full lg:grid lg:min-h-screen lg:grid-cols-2">
      <div className="hidden bg-primary lg:flex flex-col items-center justify-between p-8 text-primary-foreground">
        <div className="flex flex-col items-center text-center max-w-md mt-auto">
            <Logo size="large" />
            <AnimatedText />
        </div>
        <div className="mt-auto text-xs text-primary-foreground/70">
          v1.0.0
        </div>
      </div>
       <div className="flex items-center justify-center py-12">
        <div className="mx-auto grid w-[350px] gap-6 border p-6 rounded-lg">
          <div className="grid gap-2 text-center">
            <h1 className="text-3xl font-bold">Password Reset</h1>
            <p className="text-balance text-muted-foreground">
              Enter your email to receive a reset link
            </p>
          </div>
          <form onSubmit={handleSendLink}>
            <div className="grid gap-4">
              <div className="grid gap-2">
                <Label htmlFor="email">Email</Label>
                <Input
                  id="email"
                  type="email"
                  placeholder="m@example.com"
                  required
                  value={email}
                  onChange={(e) => setEmail(e.target.value)}
                  disabled={isSubmitting}
                />
              </div>
              <Button type="submit" className="w-full" disabled={isSubmitting}>
                {isSubmitting ? 'Sending...' : 'Send Reset Link'}
              </Button>
            </div>
          </form>
          <div className="mt-4 text-center text-sm">
            Remembered your password?{' '}
            <Link href="/login" className="underline">
              Login
            </Link>
          </div>
        </div>
      </div>
    </div>
  );
}
