// This Server Component is now much simpler.
import { PageHeader } from '@/components/page-header';
import { getTrackingDomains } from './actions';
import { DomainsDashboard } from './domains-dashboard';
// --- REMOVED: We no longer need the `headers` import here. ---

export default async function DomainsPage() {
  // 1. Fetch the user's existing domains from the database.
  const initialDomains = await getTrackingDomains();

  // --- REMOVED ---
  // The logic to dynamically detect the host is no longer needed
  // because the user will provide the target domain themselves.
  // const headersList = headers();
  // const host = headersList.get('host')!;

  return (
    <>
      <PageHeader
        title="Sending & Tracking Domains"
        description="Manage your custom domains to improve deliverability and brand presence."
      />
      {/* 2. We pass the initial domains to the dashboard. The `appDomain` prop is no longer needed.
      */}
      <DomainsDashboard
        initialDomains={initialDomains}
      />
    </>
  );
}
