// This is the main Server Component for the page.
import { PageHeader } from '@/components/page-header';
import { Button } from '@/components/ui/button';
import { FileDown, Filter } from 'lucide-react';
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuCheckboxItem,
  DropdownMenuLabel,
  DropdownMenuSeparator,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";

// --- SERVER ACTION ---
import { getAnalyticsData } from './actions';

// --- NEW CLIENT COMPONENT ---
// We import the component that contains all the charts and interactive UI.
import { AnalyticsCharts } from './analytics-charts';

// The page is an async function to allow for server-side data fetching.
export default async function AnalyticsPage() {
  // 1. Fetch the real data from the database on the server.
  const data = await getAnalyticsData();

  return (
    <>
      <PageHeader
        title="Analytics & Reporting"
        description="Track your campaign performance and audience engagement in real-time."
      >
        <div className="flex items-center gap-2">
           <DropdownMenu>
            <DropdownMenuTrigger asChild>
              <Button variant="outline"><Filter className="mr-2 h-4 w-4" /> Filter by Objective</Button>
            </DropdownMenuTrigger>
            <DropdownMenuContent className="w-56">
              <DropdownMenuLabel>Campaign Objective</DropdownMenuLabel>
              <DropdownMenuSeparator />
              <DropdownMenuCheckboxItem checked>All Objectives</DropdownMenuCheckboxItem>
              <DropdownMenuCheckboxItem>Lead Nurturing</DropdownMenuCheckboxItem>
              <DropdownMenuCheckboxItem>Sales Conversion</DropdownMenuCheckboxItem>
              <DropdownMenuCheckboxItem>Engagement/Retention</DropdownMenuCheckboxItem>
              <DropdownMenuCheckboxItem>Brand Awareness</DropdownMenuCheckboxItem>
            </DropdownMenuContent>
          </DropdownMenu>
          <Button variant="outline"><FileDown className="mr-2 h-4 w-4" /> Export Reports</Button>
        </div>
      </PageHeader>

      {/* 2. Pass the fetched data as a prop to the Client Component. */}
      <AnalyticsCharts data={data} />
    </>
  );
}
