
'use client';

import { useState, useMemo } from 'react';
import { PageHeader } from "@/components/page-header";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from "@/components/ui/table";
import { Search, ArrowLeft } from "lucide-react";
import Link from "next/link";
import { format } from 'date-fns';
import { useCampaigns } from '@/context/CampaignContext';

export default function SendingEngineLogsPage() {
  const [searchTerm, setSearchTerm] = useState('');
  const { campaigns } = useCampaigns();

    const searchedCampaigns = useMemo(() => {
        return campaigns.filter(campaign => 
            campaign.name.toLowerCase().includes(searchTerm.toLowerCase())
        );
    }, [campaigns, searchTerm]);
    

    return (
        <div className="flex flex-col h-full">
            <PageHeader
                title="Sending Engine Logs"
                description="A comprehensive list of campaigns for debugging purposes."
            />
            <Card className="flex-1">
                <CardHeader>
                    <CardTitle>Campaigns Overview</CardTitle>
                     <CardDescription>All Campaigns in the DB</CardDescription>
                    <div className="relative pt-2">
                        <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-muted-foreground" />
                        <Input
                            placeholder="Search campaigns..."
                            className="pl-10"
                            value={searchTerm}
                            onChange={(e) => setSearchTerm(e.target.value)}
                        />
                    </div>
                </CardHeader>
                <CardContent>
                    <Table>
                        <TableHeader>
                            <TableRow>
                                <TableHead>Campaign ID</TableHead>
                                <TableHead>Campaign Name</TableHead>
                                <TableHead>Status</TableHead>
                                <TableHead>Last Modified</TableHead>
                                <TableHead className="text-right">Actions</TableHead>
                            </TableRow>
                        </TableHeader>
                        <TableBody>
                            {searchedCampaigns.map(log => (
                                <TableRow key={log.id}>
                                    <TableCell className="font-medium">{log.id}</TableCell>
                                    <TableCell>{log.name}</TableCell>
                                    <TableCell>{log.status}</TableCell>
                                    <TableCell>{format(new Date(log.last_modified), 'yyyy-MM-dd HH:mm:ss')}</TableCell>
                                    <TableCell className="text-right">
                                         <Link href={`/campaigns/${log.id}/edit?view=admin`}>
                                            <Button variant="outline" size="sm">
                                                View Campaign
                                            </Button>
                                         </Link>
                                    </TableCell>
                                </TableRow>
                            ))}
                        </TableBody>
                    </Table>
                </CardContent>
            </Card>
             <div className="flex justify-end mt-6">
                <Link href="/admin">
                    <Button variant="outline">
                        <ArrowLeft className="mr-2 h-4 w-4" />
                        Back to Admin Panel
                    </Button>
                </Link>
            </div>
        </div>
    )
}
