import { z } from 'zod';
import type { RuntimeManager } from '../manager/manager';
import { type RuntimeInfo } from '../manager/types';
import type { EnvironmentVariable } from '../types/env';
export declare const TOOLS_SERVER_ROUTER: (manager: RuntimeManager) => import("@trpc/server").CreateRouterInner<import("@trpc/server").RootConfig<{
    ctx: object;
    meta: object;
    errorShape: import("@trpc/server").DefaultErrorShape | {
        data: {
            genkitErrorMessage: string;
            genkitErrorDetails: any;
            code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
            httpStatus: number;
            path?: string;
            stack?: string;
        };
        message: string;
        code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
    };
    transformer: import("@trpc/server").DefaultDataTransformer;
}>, {
    listActions: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: typeof import("@trpc/server").unsetMarker;
        _input_out: typeof import("@trpc/server").unsetMarker;
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
    }, Record<string, {
        name: string;
        key: string;
        description?: string | null | undefined;
        inputSchema?: {} | null | undefined;
        outputSchema?: {} | null | undefined;
        metadata?: Record<string, string | number | bigint | boolean | {} | (string | number | bigint | boolean | {})[]> | null | undefined;
    }>>;
    runAction: import("@trpc/server").BuildProcedure<"mutation", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            key: string;
            input?: any;
            context?: any;
            telemetryLabels?: Record<string, string> | undefined;
        };
        _input_out: {
            key: string;
            input?: any;
            context?: any;
            telemetryLabels?: Record<string, string> | undefined;
        };
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
    }, {
        result?: unknown;
        telemetry?: {
            traceId?: string | undefined;
        } | undefined;
        genkitVersion?: string | undefined;
    }>;
    createPrompt: import("@trpc/server").BuildProcedure<"mutation", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            model: string;
            messages: {
                content: ({
                    text: string;
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    reasoning: string;
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                } | {
                    media: {
                        url: string;
                        contentType?: string | undefined;
                    };
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    toolRequest: {
                        name: string;
                        ref?: string | undefined;
                        input?: unknown;
                    };
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    toolResponse: {
                        name: string;
                        ref?: string | undefined;
                        output?: unknown;
                    };
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    custom: Record<string, any>;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                })[];
                role: "system" | "user" | "model" | "tool";
                metadata?: Record<string, unknown> | undefined;
            }[];
            tools?: {
                description: string;
                name: string;
                inputSchema?: Record<string, any> | null | undefined;
                outputSchema?: Record<string, any> | null | undefined;
                metadata?: Record<string, any> | undefined;
            }[] | undefined;
            config?: z.objectInputType<{
                version: z.ZodOptional<z.ZodString>;
                temperature: z.ZodOptional<z.ZodNumber>;
                maxOutputTokens: z.ZodOptional<z.ZodNumber>;
                topK: z.ZodOptional<z.ZodNumber>;
                topP: z.ZodOptional<z.ZodNumber>;
                stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough"> | undefined;
        };
        _input_out: {
            model: string;
            messages: {
                content: ({
                    text: string;
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    reasoning: string;
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                } | {
                    media: {
                        url: string;
                        contentType?: string | undefined;
                    };
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    toolRequest: {
                        name: string;
                        ref?: string | undefined;
                        input?: unknown;
                    };
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    toolResponse: {
                        name: string;
                        ref?: string | undefined;
                        output?: unknown;
                    };
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    custom?: Record<string, unknown> | undefined;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                } | {
                    custom: Record<string, any>;
                    metadata?: Record<string, unknown> | undefined;
                    text?: undefined;
                    media?: undefined;
                    toolRequest?: undefined;
                    toolResponse?: undefined;
                    data?: unknown;
                    reasoning?: undefined;
                })[];
                role: "system" | "user" | "model" | "tool";
                metadata?: Record<string, unknown> | undefined;
            }[];
            tools?: {
                description: string;
                name: string;
                inputSchema?: Record<string, any> | null | undefined;
                outputSchema?: Record<string, any> | null | undefined;
                metadata?: Record<string, any> | undefined;
            }[] | undefined;
            config?: z.objectOutputType<{
                version: z.ZodOptional<z.ZodString>;
                temperature: z.ZodOptional<z.ZodNumber>;
                maxOutputTokens: z.ZodOptional<z.ZodNumber>;
                topK: z.ZodOptional<z.ZodNumber>;
                topP: z.ZodOptional<z.ZodNumber>;
                stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, z.ZodTypeAny, "passthrough"> | undefined;
        };
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
    }, string>;
    listTraces: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            filter?: {
                eq?: Record<string, string | number> | undefined;
                neq?: Record<string, string | number> | undefined;
            } | undefined;
            limit?: number | undefined;
            continuationToken?: string | undefined;
        };
        _input_out: {
            filter?: {
                eq?: Record<string, string | number> | undefined;
                neq?: Record<string, string | number> | undefined;
            } | undefined;
            limit?: number | undefined;
            continuationToken?: string | undefined;
        };
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
    }, {
        traces: {
            traceId: string;
            spans: Record<string, {
                traceId: string;
                spanId: string;
                displayName: string;
                attributes: Record<string, unknown>;
                startTime: number;
                endTime: number;
                instrumentationLibrary: {
                    name: string;
                    version?: string | undefined;
                    schemaUrl?: string | undefined;
                };
                spanKind: string;
                status?: {
                    code: number;
                    message?: string | undefined;
                } | undefined;
                parentSpanId?: string | undefined;
                links?: {
                    context?: {
                        traceId: string;
                        spanId: string;
                        traceFlags: number;
                        isRemote?: boolean | undefined;
                    } | undefined;
                    attributes?: Record<string, unknown> | undefined;
                    droppedAttributesCount?: number | undefined;
                }[] | undefined;
                sameProcessAsParentSpan?: {
                    value: boolean;
                } | undefined;
                timeEvents?: {
                    timeEvent?: {
                        time: number;
                        annotation: {
                            description: string;
                            attributes: Record<string, unknown>;
                        };
                    }[] | undefined;
                } | undefined;
                truncated?: boolean | undefined;
            }>;
            displayName?: string | undefined;
            startTime?: number | undefined;
            endTime?: number | undefined;
        }[];
        continuationToken?: string | undefined;
    }>;
    getTrace: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            traceId: string;
        };
        _input_out: {
            traceId: string;
        };
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
    }, {
        traceId: string;
        spans: Record<string, {
            traceId: string;
            spanId: string;
            displayName: string;
            attributes: Record<string, unknown>;
            startTime: number;
            endTime: number;
            instrumentationLibrary: {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            };
            spanKind: string;
            status?: {
                code: number;
                message?: string | undefined;
            } | undefined;
            parentSpanId?: string | undefined;
            links?: {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }[] | undefined;
            sameProcessAsParentSpan?: {
                value: boolean;
            } | undefined;
            timeEvents?: {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            } | undefined;
            truncated?: boolean | undefined;
        }>;
        displayName?: string | undefined;
        startTime?: number | undefined;
        endTime?: number | undefined;
    }>;
    listEvalRunKeys: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            filter?: {
                actionRef?: string | undefined;
            } | undefined;
        };
        _input_out: {
            filter?: {
                actionRef?: string | undefined;
            } | undefined;
        };
        _output_in: {
            evalRunKeys: {
                evalRunId: string;
                createdAt: string;
                actionRef?: string | undefined;
                datasetId?: string | undefined;
                datasetVersion?: number | undefined;
                actionConfig?: any;
                metricSummaries?: Record<string, any>[] | undefined;
            }[];
        };
        _output_out: {
            evalRunKeys: {
                evalRunId: string;
                createdAt: string;
                actionRef?: string | undefined;
                datasetId?: string | undefined;
                datasetVersion?: number | undefined;
                actionConfig?: any;
                metricSummaries?: Record<string, any>[] | undefined;
            }[];
        };
    }, unknown>;
    getEvalRun: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            name: string;
        };
        _input_out: {
            name: string;
        };
        _output_in: {
            key: {
                evalRunId: string;
                createdAt: string;
                actionRef?: string | undefined;
                datasetId?: string | undefined;
                datasetVersion?: number | undefined;
                actionConfig?: any;
                metricSummaries?: Record<string, any>[] | undefined;
            };
            results: {
                testCaseId: string;
                traceIds: string[];
                input?: any;
                output?: any;
                error?: string | undefined;
                context?: any[] | undefined;
                reference?: any;
                metrics?: {
                    evaluator: string;
                    status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
                    traceId?: string | undefined;
                    error?: string | undefined;
                    scoreId?: string | undefined;
                    score?: string | number | boolean | undefined;
                    rationale?: string | undefined;
                    spanId?: string | undefined;
                }[] | undefined;
            }[];
            metricsMetadata?: Record<string, {
                displayName: string;
                definition: string;
            }> | undefined;
        };
        _output_out: {
            key: {
                evalRunId: string;
                createdAt: string;
                actionRef?: string | undefined;
                datasetId?: string | undefined;
                datasetVersion?: number | undefined;
                actionConfig?: any;
                metricSummaries?: Record<string, any>[] | undefined;
            };
            results: {
                testCaseId: string;
                traceIds: string[];
                input?: any;
                output?: any;
                error?: string | undefined;
                context?: any[] | undefined;
                reference?: any;
                metrics?: {
                    evaluator: string;
                    status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
                    traceId?: string | undefined;
                    error?: string | undefined;
                    scoreId?: string | undefined;
                    score?: string | number | boolean | undefined;
                    rationale?: string | undefined;
                    spanId?: string | undefined;
                }[] | undefined;
            }[];
            metricsMetadata?: Record<string, {
                displayName: string;
                definition: string;
            }> | undefined;
        };
    }, unknown>;
    deleteEvalRun: import("@trpc/server").BuildProcedure<"mutation", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            name: string;
        };
        _input_out: {
            name: string;
        };
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
    }, void>;
    listDatasets: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: typeof import("@trpc/server").unsetMarker;
        _input_out: typeof import("@trpc/server").unsetMarker;
        _output_in: {
            version: number;
            datasetId: string;
            size: number;
            datasetType: "UNKNOWN" | "FLOW" | "MODEL";
            createTime: string;
            updateTime: string;
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            targetAction?: string | undefined;
            metricRefs?: string[] | undefined;
        }[];
        _output_out: {
            version: number;
            datasetId: string;
            size: number;
            datasetType: "UNKNOWN" | "FLOW" | "MODEL";
            metricRefs: string[];
            createTime: string;
            updateTime: string;
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            targetAction?: string | undefined;
        }[];
    }, unknown>;
    getDataset: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: string;
        _input_out: string;
        _output_in: {
            testCaseId: string;
            input?: any;
            reference?: any;
        }[];
        _output_out: {
            testCaseId: string;
            input?: any;
            reference?: any;
        }[];
    }, unknown>;
    createDataset: import("@trpc/server").BuildProcedure<"mutation", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            data: {
                input?: any;
                testCaseId?: string | undefined;
                reference?: any;
            }[];
            datasetType: "UNKNOWN" | "FLOW" | "MODEL";
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            datasetId?: string | undefined;
            targetAction?: string | undefined;
            metricRefs?: string[] | undefined;
        };
        _input_out: {
            data: {
                input?: any;
                testCaseId?: string | undefined;
                reference?: any;
            }[];
            datasetType: "UNKNOWN" | "FLOW" | "MODEL";
            metricRefs: string[];
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            datasetId?: string | undefined;
            targetAction?: string | undefined;
        };
        _output_in: {
            version: number;
            datasetId: string;
            size: number;
            datasetType: "UNKNOWN" | "FLOW" | "MODEL";
            createTime: string;
            updateTime: string;
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            targetAction?: string | undefined;
            metricRefs?: string[] | undefined;
        };
        _output_out: {
            version: number;
            datasetId: string;
            size: number;
            datasetType: "UNKNOWN" | "FLOW" | "MODEL";
            metricRefs: string[];
            createTime: string;
            updateTime: string;
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            targetAction?: string | undefined;
        };
    }, unknown>;
    updateDataset: import("@trpc/server").BuildProcedure<"mutation", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            datasetId: string;
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            data?: {
                input?: any;
                testCaseId?: string | undefined;
                reference?: any;
            }[] | undefined;
            targetAction?: string | undefined;
            metricRefs?: string[] | undefined;
        };
        _input_out: {
            datasetId: string;
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            data?: {
                input?: any;
                testCaseId?: string | undefined;
                reference?: any;
            }[] | undefined;
            targetAction?: string | undefined;
            metricRefs?: string[] | undefined;
        };
        _output_in: {
            version: number;
            datasetId: string;
            size: number;
            datasetType: "UNKNOWN" | "FLOW" | "MODEL";
            createTime: string;
            updateTime: string;
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            targetAction?: string | undefined;
            metricRefs?: string[] | undefined;
        };
        _output_out: {
            version: number;
            datasetId: string;
            size: number;
            datasetType: "UNKNOWN" | "FLOW" | "MODEL";
            metricRefs: string[];
            createTime: string;
            updateTime: string;
            schema?: {
                inputSchema?: Record<string, any> | undefined;
                referenceSchema?: Record<string, any> | undefined;
            } | undefined;
            targetAction?: string | undefined;
        };
    }, unknown>;
    deleteDataset: import("@trpc/server").BuildProcedure<"mutation", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: string;
        _input_out: string;
        _output_in: void;
        _output_out: void;
    }, unknown>;
    runNewEvaluation: import("@trpc/server").BuildProcedure<"mutation", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            actionRef: string;
            dataSource: {
                data?: {
                    input?: any;
                    testCaseId?: string | undefined;
                    reference?: any;
                }[] | undefined;
                datasetId?: string | undefined;
            };
            options?: {
                context?: string | undefined;
                actionConfig?: any;
                batchSize?: number | undefined;
            } | undefined;
            evaluators?: string[] | undefined;
        };
        _input_out: {
            actionRef: string;
            dataSource: {
                data?: {
                    input?: any;
                    testCaseId?: string | undefined;
                    reference?: any;
                }[] | undefined;
                datasetId?: string | undefined;
            };
            options?: {
                context?: string | undefined;
                actionConfig?: any;
                batchSize?: number | undefined;
            } | undefined;
            evaluators?: string[] | undefined;
        };
        _output_in: {
            evalRunId: string;
            createdAt: string;
            actionRef?: string | undefined;
            datasetId?: string | undefined;
            datasetVersion?: number | undefined;
            actionConfig?: any;
            metricSummaries?: Record<string, any>[] | undefined;
        };
        _output_out: {
            evalRunId: string;
            createdAt: string;
            actionRef?: string | undefined;
            datasetId?: string | undefined;
            datasetVersion?: number | undefined;
            actionConfig?: any;
            metricSummaries?: Record<string, any>[] | undefined;
        };
    }, unknown>;
    validateDatasetSchema: import("@trpc/server").BuildProcedure<"mutation", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: {};
        _input_in: {
            actionRef: string;
            dataSource: {
                data?: {
                    input?: any;
                    testCaseId?: string | undefined;
                    reference?: any;
                }[] | undefined;
                datasetId?: string | undefined;
            };
        };
        _input_out: {
            actionRef: string;
            dataSource: {
                data?: {
                    input?: any;
                    testCaseId?: string | undefined;
                    reference?: any;
                }[] | undefined;
                datasetId?: string | undefined;
            };
        };
        _output_in: {
            valid: boolean;
            errors?: Record<string, {
                path: string;
                message: string;
            }[]> | undefined;
        };
        _output_out: {
            valid: boolean;
            errors?: Record<string, {
                path: string;
                message: string;
            }[]> | undefined;
        };
    }, unknown>;
    sendPageView: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _meta: object;
        _ctx_out: object;
        _input_in: {
            pageTitle: string;
        };
        _input_out: {
            pageTitle: string;
        };
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
    }, void>;
    getGenkitEnvironment: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _ctx_out: object;
        _input_in: typeof import("@trpc/server").unsetMarker;
        _input_out: typeof import("@trpc/server").unsetMarker;
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
        _meta: object;
    }, {
        cliPackageVersion: any;
        environmentVars: EnvironmentVariable[];
    }>;
    getCurrentRuntime: import("@trpc/server").BuildProcedure<"query", {
        _config: import("@trpc/server").RootConfig<{
            ctx: object;
            meta: object;
            errorShape: import("@trpc/server").DefaultErrorShape | {
                data: {
                    genkitErrorMessage: string;
                    genkitErrorDetails: any;
                    code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_KEY;
                    httpStatus: number;
                    path?: string;
                    stack?: string;
                };
                message: string;
                code: import("@trpc/server/dist/rpc").TRPC_ERROR_CODE_NUMBER;
            };
            transformer: import("@trpc/server").DefaultDataTransformer;
        }>;
        _ctx_out: object;
        _input_in: typeof import("@trpc/server").unsetMarker;
        _input_out: typeof import("@trpc/server").unsetMarker;
        _output_in: typeof import("@trpc/server").unsetMarker;
        _output_out: typeof import("@trpc/server").unsetMarker;
        _meta: object;
    }, RuntimeInfo>;
}>;
export type ToolsServerRouter = ReturnType<typeof TOOLS_SERVER_ROUTER>;
