import type { ListEvalKeysRequest, ListEvalKeysResponse } from '../types/apis';
import { type EvalRun, type EvalStore } from '../types/eval';
export declare class LocalFileEvalStore implements EvalStore {
    private readonly storeRoot;
    private readonly indexFile;
    private readonly INDEX_DELIMITER;
    private static cachedEvalStore;
    private constructor();
    static getEvalStore(): LocalFileEvalStore;
    static reset(): void;
    save(evalRun: EvalRun): Promise<void>;
    load(evalRunId: string): Promise<EvalRun | undefined>;
    list(query?: ListEvalKeysRequest | undefined): Promise<ListEvalKeysResponse>;
    delete(evalRunId: string): Promise<void>;
    private generateFileName;
    private getIndexFilePath;
    private parseLineToKey;
    private generateRootPath;
    private deleteEvalRunFromIndex;
}
