"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PromptFrontmatterSchema = void 0;
const zod_1 = require("zod");
const model_1 = require("./model");
exports.PromptFrontmatterSchema = zod_1.z.object({
    name: zod_1.z.string().optional(),
    variant: zod_1.z.string().optional(),
    model: zod_1.z.string().optional(),
    tools: zod_1.z.array(zod_1.z.string()).optional(),
    candidates: zod_1.z.number().optional(),
    config: model_1.GenerationCommonConfigSchema.passthrough().optional(),
    input: zod_1.z
        .object({
        schema: zod_1.z.unknown(),
        default: zod_1.z.any(),
    })
        .optional(),
    output: zod_1.z
        .object({
        format: zod_1.z.enum(['json', 'text', 'media']).optional(),
        schema: zod_1.z.unknown().optional(),
    })
        .optional(),
    metadata: zod_1.z.record(zod_1.z.unknown()).optional(),
});
//# sourceMappingURL=prompt.js.map