"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var imagen_exports = {};
__export(imagen_exports, {
  GENERIC_IMAGEN_INFO: () => GENERIC_IMAGEN_INFO,
  ImagenConfigSchema: () => ImagenConfigSchema,
  defineImagenModel: () => defineImagenModel
});
module.exports = __toCommonJS(imagen_exports);
var import_genkit = require("genkit");
var import_model = require("genkit/model");
var import_common = require("./common.js");
var import_predict = require("./predict.js");
const ImagenConfigSchema = import_genkit.z.object({
  numberOfImages: import_genkit.z.number().describe(
    "The number of images to generate, from 1 to 4 (inclusive). The default is 1."
  ).optional(),
  aspectRatio: import_genkit.z.enum(["1:1", "9:16", "16:9", "3:4", "4:3"]).describe("Desired aspect ratio of the output image.").optional(),
  personGeneration: import_genkit.z.enum(["dont_allow", "allow_adult", "allow_all"]).describe(
    "Control if/how images of people will be generated by the model."
  ).optional()
}).passthrough();
function toParameters(request) {
  const out = {
    sampleCount: request.config?.numberOfImages ?? 1,
    ...request?.config
  };
  for (const k in out) {
    if (!out[k]) delete out[k];
  }
  return out;
}
function extractText(request) {
  return request.messages.at(-1).content.map((c) => c.text || "").join("");
}
function extractBaseImage(request) {
  return request.messages.at(-1)?.content.find((p) => !!p.media)?.media?.url.split(",")[1];
}
const GENERIC_IMAGEN_INFO = {
  label: `Google AI - Generic Imagen`,
  supports: {
    media: true,
    multiturn: false,
    tools: false,
    systemRole: false,
    output: ["media"]
  }
};
function defineImagenModel(ai, name, apiKey) {
  if (apiKey !== false) {
    apiKey = apiKey || (0, import_common.getApiKeyFromEnvVar)();
    if (!apiKey) {
      throw new import_genkit.GenkitError({
        status: "FAILED_PRECONDITION",
        message: "Please pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai"
      });
    }
  }
  const modelName = `googleai/${name}`;
  const model = (0, import_model.modelRef)({
    name: modelName,
    info: {
      ...GENERIC_IMAGEN_INFO,
      label: `Google AI - ${name}`
    },
    configSchema: ImagenConfigSchema
  });
  return ai.defineModel(
    {
      name: modelName,
      ...model.info,
      configSchema: ImagenConfigSchema
    },
    async (request) => {
      const instance = {
        prompt: extractText(request)
      };
      const baseImage = extractBaseImage(request);
      if (baseImage) {
        instance.image = { bytesBase64Encoded: baseImage };
      }
      const predictClient = (0, import_predict.predictModel)(model.version || name, apiKey, "predict");
      const response = await predictClient([instance], toParameters(request));
      if (!response.predictions || response.predictions.length == 0) {
        throw new Error(
          "Model returned no predictions. Possibly due to content filters."
        );
      }
      const message = {
        role: "model",
        content: []
      };
      response.predictions.forEach((p, i) => {
        const b64data = p.bytesBase64Encoded;
        const mimeType = p.mimeType;
        message.content.push({
          media: {
            url: `data:${mimeType};base64,${b64data}`,
            contentType: mimeType
          }
        });
      });
      return {
        finishReason: "stop",
        message,
        usage: (0, import_model.getBasicUsageStats)(request.messages, message),
        custom: response
      };
    }
  );
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  GENERIC_IMAGEN_INFO,
  ImagenConfigSchema,
  defineImagenModel
});
//# sourceMappingURL=imagen.js.map