module.exports = {
  /**
   * --- THIS SECTION IS NOW UPGRADED ---
   * The 'apps' array now correctly defines both your Next.js web application
   * and the standalone delivery worker, ensuring PM2 manages both.
   */
  apps: [
    {
      // This is your main Next.js web application
      name: 'Mailer-ai-Web-App',
      script: 'npm',
      args: 'start',
      instances: 'max', // Run one instance per CPU core for max performance
      exec_mode: 'cluster',
      env_production: {
        NODE_ENV: 'production',
        PORT: 3000, // Or whatever port you use
      },
    },
    {
      // --- THIS IS YOUR DELIVERY WORKER ---
      name: 'Mailer-ai-Delivery-Worker',
      // The path to the compiled JavaScript file from Step 1
      script: './dist/delivery-worker.js',
      // We only need one instance of the worker running
      instances: 1,
      exec_mode: 'fork',
      // This is crucial: it tells PM2 to watch for crashes and restart automatically
      autorestart: true,
      watch: false, // Don't watch for file changes in production
      max_memory_restart: '1G', // Restart if it uses too much memory
      env_production: {
        NODE_ENV: 'production',
      },
    },
  ],

  /**
   * --- THIS SECTION IS PRESERVED ---
   * Your existing deployment script is kept, allowing you to continue
   * using your automated deployment workflow. It will now manage both apps.
   */
  deploy: {
    production: {
      user: 'root',
      host: '157.230.189.189',
      path: '/root/smartmail_ai',
      'pre-deploy-local': '',
      'post-deploy': 'npm install && npm run build && npm run build:worker && pm2 reload ecosystem.config.js --env production',
      'pre-setup': ''
    }
  }
};



module.exports = {
  apps: [
    {
      // This is your main Next.js web application
      name: 'Mailer-ai-Web-App',
      script: 'npm',
      args: 'start',
      instances: 'max', // Run one instance per CPU core for max performance
      exec_mode: 'cluster',
      env_production: {
        NODE_ENV: 'production',
        PORT: 3000, // Or whatever port you use
      },
    },
    {
      // --- THIS IS YOUR DELIVERY WORKER ---
      name: 'Mailer-ai-Delivery-Worker',
      // The path to the compiled JavaScript file from Step 1
      script: './dist/delivery-worker.js',
      // We only need one instance of the worker running
      instances: 1,
      exec_mode: 'fork',
      // This is crucial: it tells PM2 to watch for crashes and restart automatically
      autorestart: true,
      watch: false, // Don't watch for file changes in production
      max_memory_restart: '1G', // Restart if it uses too much memory
      env_production: {
        NODE_ENV: 'production',
      },
    },
  ],
};
```

---

### Step 3: The Production Deployment Workflow

Now, when you deploy your application to your live server, your workflow will be simple and robust.

1.  **SSH into your server** and pull your latest code.
2.  **Install PM2 Globally:** If you haven't already, run this command once on your server:
    ```bash
    npm install pm2 -g
    ```
3.  **Build Your Application:** Run your standard build commands.
    ```bash
    npm install
    npm run build         # This builds your Next.js app
    npm run build:worker  # This builds your delivery worker
    ```
4.  **Start Everything with PM2:** This is the final, magic command. Instead of running `npm start` and `npx ts-node` in separate terminals, you will run one single command:
    ```bash
    pm2 start ecosystem.config.js --env production