# SmartMail AI

This is a Next.js application built with Firebase Studio. It's an AI-powered email campaign management tool.

## Getting Started

1.  **Install dependencies:**
    ```bash
    npm install
    ```

2.  **Set up environment variables:**
    Create a `.env` file in the root of the project and add your SMTP credentials and application URL. See `.env.example` for the required variables.

3.  **Run the development server:**
    ```bash
    npm run dev
    ```

4.  **Run Genkit (for AI features):**
    In a separate terminal, start the Genkit development server:
    ```bash
    npm run genkit:dev
    ```

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

## Key Features

*   **User Authentication**: Secure login, signup, and password reset functionality.
*   **Admin Panel**: Manage users, view system-wide logs, and oversee all campaigns.
*   **AI-Powered Content**: Generate email drafts and replies using generative AI.
*   **Campaign Management**: Create, edit, and launch multi-step email campaigns.
*   **Audience & Prospect Management**: Import and manage lists of contacts.
*   **Template System**: Create and reuse email templates.
*   **One-Off Email Sender**: Quickly send single emails using templates.
*   **Analytics & Reporting**: Track campaign performance.
*   **API Access**: Manage API keys and view usage.
