'use client';

import React from 'react';
import { Editor } from '@tinymce/tinymce-react';

export function TinyMCEEditor({ value, onEditorChange }: { value: string; onEditorChange: (content: string) => void }) {
  const apiKey = process.env.NEXT_PUBLIC_TINYMCE_API_KEY;

  if (!apiKey) {
    console.error("TinyMCE API key is not configured in .env.local");
    return <div className="p-4 border rounded-md bg-destructive/10 text-destructive">TinyMCE API Key is missing.</div>;
  }

  return (
    <Editor
      apiKey={apiKey}
      value={value}
      onEditorChange={(content, editor) => onEditorChange(content)}
      init={{
        height: 300,
        menubar: false,
        plugins: [
          'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
          'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
          'insertdatetime', 'media', 'table', 'help', 'wordcount'
        ],
        toolbar: 'undo redo | blocks | code ' +
          'bold italic forecolor | alignleft aligncenter ' +
          'alignright alignjustify | bullist numlist outdent indent | ' +
          'removeformat | image media link | help',
        content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:14px }',
        // This allows for image uploads, you'll need to configure a backend handler
        images_upload_url: '/api/upload',
        automatic_uploads: true,
      }}
    />
  );
}
