
import React from 'react';
import { Mail } from 'lucide-react';
import { cn } from '@/lib/utils';
import { cva, type VariantProps } from 'class-variance-authority';

const logoVariants = cva('flex items-center', {
  variants: {
    size: {
      normal: 'gap-2',
      large: 'gap-4',
    },
  },
  defaultVariants: {
    size: 'normal',
  },
});

const iconContainerVariants = cva('bg-primary-foreground text-primary flex-shrink-0', {
  variants: {
    size: {
      normal: 'p-1.5 rounded-lg',
      large: 'p-2 rounded-xl',
    },
  },
  defaultVariants: {
    size: 'normal',
  },
});

const iconVariants = cva('', {
  variants: {
    size: {
      normal: 'w-6 h-6',
      large: 'w-8 h-8',
    },
  },
  defaultVariants: {
    size: 'normal',
  },
});

const textContainerVariants = cva('flex flex-col font-headline leading-none text-primary-foreground', {
    variants: {
        size: {
            normal: 'items-start',
            large: 'items-start',
        }
    },
    defaultVariants: {
        size: 'normal'
    }
});


const textVariants = cva('whitespace-nowrap font-bold', {
  variants: {
    size: {
      normal: 'text-xl',
      large: 'text-3xl',
    },
  },
  defaultVariants: {
    size: 'normal',
  },
});

const subtextVariants = cva('whitespace-nowrap text-primary-foreground/90 font-body font-normal', {
    variants: {
        size: {
            normal: 'text-xs',
            large: 'text-sm mt-1',
        },
    },
    defaultVariants: {
        size: 'normal',
    },
});

export interface LogoProps extends VariantProps<typeof logoVariants> {
  className?: string;
  iconOnly?: boolean;
}

export function Logo({ className, iconOnly = false, size = 'normal' }: LogoProps) {
  return (
    <div className={cn(logoVariants({ size }), className)}>
        <div className={cn(iconContainerVariants({ size }))}>
            <Mail className={cn(iconVariants({ size }))} />
        </div>
        {!iconOnly && (
            <div className={cn(textContainerVariants({size}))}>
                <span className={cn(textVariants({ size }))}>SmartMail AI</span>
                {size === 'large' && <p className={cn(subtextVariants({ size }))}>Automate, Personalize, Convert.</p>}
            </div>
        )}
    </div>
  );
}
