
'use client';

import { useState, useEffect } from 'react';
import { cn } from '@/lib/utils';

const texts = [
    "Email campaigns? Fully automated. From first draft to final send.",
    "AI-built audiences. Laser-focused reach. Talk to the right people every time.",
    "Smart sequences that write themselves. Tailored. Timely. Powerful.",
    "Outreach, redefined. Compliance built-in. Analytics on point."
];

export function AnimatedText() {
    const [index, setIndex] = useState(0);
    const [animation, setAnimation] = useState('fade-in');

    useEffect(() => {
        const interval = setInterval(() => {
            setAnimation('fade-out');
            setTimeout(() => {
                setIndex(prevIndex => (prevIndex + 1) % texts.length);
                setAnimation('fade-in');
            }, 800); // Should match fadeOut animation duration
        }, 5000); // Time each text is displayed

        return () => clearInterval(interval);
    }, []);

    return (
        <div className="mt-8 text-lg font-medium text-primary-foreground/90 h-24">
            <p className={cn("transition-opacity duration-500", animation)}>
                {texts[index]}
            </p>
        </div>
    );
}
