'use server';

import { pool } from '@/lib/db';
import sql from 'sql-template-strings';
import bcrypt from 'bcrypt';
import { revalidatePath } from 'next/cache';

export async function signup(formData: FormData): Promise<{ error: string } | void> {
    const name = formData.get('fullName') as string;
    const email = formData.get('email') as string;
    const password = formData.get('password') as string;

    if (!name || !email || !password) {
        return { error: 'All fields are required.' };
    }

    try {
        const { rows: existingUsers } = await pool.query(sql`SELECT email FROM users WHERE email = ${email}`);
        if (existingUsers.length > 0) {
            return { error: 'An account with this email already exists.' };
        }

        const hashedPassword = await bcrypt.hash(password, 10);
        const apiKey = `sk_live_${crypto.randomUUID().replace(/-/g, '').substring(0, 24)}`;

        await pool.query(sql`
            INSERT INTO users (name, email, password, role, credits, api_key, profile_pic_url)
            VALUES (${name}, ${email}, ${hashedPassword}, 'Consumer', 5000, ${apiKey}, null)
        `);

        revalidatePath('/admin');

    } catch (error) {
        console.error('Signup error:', error);
        return { error: 'An internal server error occurred.' };
    }
}
