
'use server';

import { pool } from '@/lib/db';
import sql from 'sql-template-strings';
import bcrypt from 'bcrypt';
import type { User } from '@/lib/types';
import { revalidatePath } from 'next/cache';

export async function login(formData: FormData): Promise<{ success: boolean; error?: string, user?: User }> {
  const email = formData.get('email') as string;
  const password = formData.get('password') as string;

  if (!email || !password) {
      return { success: false, error: 'Email and password are required.' };
  }

  try {
      // Special handling for the default admin user
      if (email === 'admin@smartmailai.com' && password === 'admin@') {
        let { rows: adminRows } = await pool.query(sql`SELECT * FROM users WHERE email = ${email}`);

        // If admin doesn't exist, create it
        if (adminRows.length === 0) {
            console.log('Default admin user not found, creating it...');
            const hashedPassword = await bcrypt.hash(password, 10);
            const adminApiKey = `sk_live_${crypto.randomUUID().replace(/-/g, '').substring(0, 24)}`;

            await pool.query(sql`
                INSERT INTO users (id, name, email, password, role, credits, api_key)
                VALUES ('ADMIN001', 'Admin', 'admin@smartmailai.com', ${hashedPassword}, 'Admin', -1, ${adminApiKey})
                ON CONFLICT (email) DO NOTHING
            `);
            console.log('Default admin user created.');
             ({ rows: adminRows } = await pool.query(sql`SELECT * FROM users WHERE email = ${email}`));
        }

        const adminUser = adminRows[0];
        const passwordMatch = await bcrypt.compare(password, adminUser.password);

        if (passwordMatch) {
            const { password: _, ...userWithoutPassword } = adminUser;
            return { success: true, user: userWithoutPassword };
        }
      }

      const { rows } = await pool.query(sql`SELECT id, name, email, password, role, credits, api_key FROM users WHERE email = ${email}`);
      if (rows.length === 0) {
          return { success: false, error: 'Invalid email or password.' };
      }

      const user = rows[0];
      const passwordMatch = await bcrypt.compare(password, user.password);

      if (!passwordMatch) {
          return { success: false, error: 'Invalid email or password.' };
      }

      const { password: _, ...userWithoutPassword } = user;

      return { success: true, user: userWithoutPassword };

  } catch (error) {
      console.error('Login error:', error);
      return { success: false, error: 'An internal server error occurred.' };
  }
}
