import { getSenderData } from './actions';
import { SendingSettingsForm } from './sending-form';
import { PageHeader } from '@/components/page-header'; // Assuming you have a PageHeader component

export default async function SendingSettingsPage() {
  // 1. Fetch data on the server using a server action.
  // This happens before the page is sent to the browser.
  const initialData = await getSenderData();

  if (initialData.error) {
    return (
      <div className="container mx-auto p-4">
        <h1 className="text-2xl font-bold text-red-600">Error</h1>
        <p>{initialData.error}</p>
      </div>
    );
  }

  return (
    <div className="space-y-8 p-4 md:p-6">
      <PageHeader
        title="Sending Settings"
        description="Configure your email sending services and domains."
      />

      {/* 2. Pass the server-fetched data as props to the client component. */}
      <SendingSettingsForm
        initialGmailSenders={initialData.gmailSenders}
        initialPlatformSenders={initialData.platformSenders}
        initialCustomSenders={initialData.customSenders}
      />
    </div>
  );
}
