
'use client';

import { PageHeader } from "@/components/page-header";
import { Accordion, AccordionContent, AccordionItem, AccordionTrigger } from "@/components/ui/accordion";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from "@/components/ui/table";
import { FileText, HelpCircle, X } from "lucide-react";
import { Button } from "@/components/ui/button";
import { useRouter } from "next/navigation";


const faqs = [
    {
        question: "How do I get an API key?",
        answer: "Your API key is automatically generated when you create an account. You can find it on your API Access page. If you don't see one, please contact support."
    },
    {
        question: "Can I generate a new API key?",
        answer: "Yes, administrators can generate a new API key for any user or for themselves. If you are not an admin, you can delete your current key and a new one can be generated by an admin for you."
    },
    {
        question: "How is billing for API usage calculated?",
        answer: "Billing is based on the number of API calls and data enrichment requests you make within a billing cycle. You can monitor your usage on the API Access page. Overage fees may apply if you exceed your plan's limits."
    },
    {
        question: "What happens if my API key is compromised?",
        answer: "If you suspect your API key has been compromised, you should delete it immediately from your API Access page. An administrator can then generate a new, secure key for you."
    },
    {
        question: "Where can I find the full API reference?",
        answer: "Our full API reference documentation with all endpoints, request/response examples, and SDKs is available at docs.smartmailai.com. (Note: this is a sample URL)."
    }
];

export default function ApiDocsPage() {
    const router = useRouter();

    return (
        <>
            <PageHeader
                title="API Documentation"
                description="Information on billing, usage, and frequently asked questions."
            >
                <Button variant="ghost" size="icon" onClick={() => router.back()}>
                    <X className="h-6 w-6" />
                </Button>
            </PageHeader>
            <div className="grid gap-8">
                <Card>
                    <CardHeader>
                        <CardTitle className="flex items-center gap-2">
                            <FileText />
                            Billing & Usage
                        </CardTitle>
                        <CardDescription>
                            Our API billing is designed to be simple and scalable.
                        </CardDescription>
                    </CardHeader>
                    <CardContent>
                        <Table>
                            <TableHeader>
                                <TableRow>
                                    <TableHead>Metric</TableHead>
                                    <TableHead>Description</TableHead>
                                    <TableHead className="text-right">Rate</TableHead>
                                </TableRow>
                            </TableHeader>
                            <TableBody>
                                <TableRow>
                                    <TableCell className="font-medium">API Calls</TableCell>
                                    <TableCell>Standard requests to the API, such as generating email drafts or fetching campaign data.</TableCell>
                                    <TableCell className="text-right">$0.02 / call</TableCell>
                                </TableRow>
                                <TableRow>
                                    <TableCell className="font-medium">Data Enrichment</TableCell>
                                    <TableCell>Calls that enrich prospect data using our internal database or third-party sources.</TableCell>
                                    <TableCell className="text-right">$0.15 / call</TableCell>
                                </TableRow>
                                <TableRow>
                                    <TableCell className="font-medium">Email Sends</TableCell>
                                    <TableCell>Each email sent through the platform via API counts towards this metric.</TableCell>
                                    <TableCell className="text-right">$0.01 / email</TableCell>
                                </TableRow>
                            </TableBody>
                        </Table>
                         <p className="text-sm text-muted-foreground mt-4">
                            Note: Rates are indicative and may vary based on your subscription plan. Your current usage and billing total are available on the main API Access page.
                        </p>
                    </CardContent>
                </Card>

                 <Card>
                    <CardHeader>
                        <CardTitle className="flex items-center gap-2">
                            <HelpCircle />
                            Frequently Asked Questions
                        </CardTitle>
                        <CardDescription>
                            Find answers to common questions about our API.
                        </CardDescription>
                    </CardHeader>
                    <CardContent>
                        <Accordion type="single" collapsible className="w-full">
                            {faqs.map((faq, index) => (
                                <AccordionItem key={index} value={`item-${index}`}>
                                    <AccordionTrigger>{faq.question}</AccordionTrigger>
                                    <AccordionContent>
                                        {faq.answer}
                                    </AccordionContent>
                                </AccordionItem>
                            ))}
                        </Accordion>
                    </CardContent>
                </Card>
            </div>
        </>
    );
}
