
'use server';

import type { Prospect } from '@/lib/types';
import { getProspectsFromDb } from '@/lib/db';


export async function getProspects(userId: string): Promise<Prospect[]> {
    if (!userId) {
        throw new Error('Unauthorized');
    }
    try {
        const prospects = await getProspectsFromDb(userId);
        return prospects;
    } catch (error) {
        console.error('Failed to fetch prospects:', error);
        return [];
    }
}
