
'use client';

import { PageHeader } from '@/components/page-header';
import { Button } from '@/components/ui/button';
import { LayoutTemplate } from 'lucide-react';
import { useRouter } from 'next/navigation';

export default function NewAiDraftPage() {
  const router = useRouter();

  return (
    <div className="flex flex-col h-[calc(100vh-8rem)]">
      <PageHeader
        title="AI Mail Generation"
        description="Create powerful email campaigns using the form below."
      />
      <div className="flex-1 w-full border rounded-lg overflow-hidden">
        <iframe
          src="https://form5.exactprospect.com/"
          className="w-full h-full border-0"
          title="AI Mail Generation Form"
        />
      </div>
      <div className="flex justify-end mt-6">
        <Button onClick={() => router.push('/templates')}>
          <LayoutTemplate className="mr-2 h-4 w-4" />
          Go to Templates
        </Button>
      </div>
    </div>
  );
}
