"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDisabledOptionSupported = exports.getTinymceOrError = exports.setMode = exports.isInDoc = exports.isBeforeInputEventAvailable = exports.mergePlugins = exports.isTextareaOrInput = exports.uuid = exports.configHandlers = exports.configHandlers2 = exports.isFunction = void 0;
var EditorPropTypes_1 = require("./components/EditorPropTypes");
var TinyMCE_1 = require("./TinyMCE");
var isFunction = function (x) { return typeof x === 'function'; };
exports.isFunction = isFunction;
var isEventProp = function (name) { return name in EditorPropTypes_1.eventPropTypes; };
var eventAttrToEventName = function (attrName) { return attrName.substr(2); };
var configHandlers2 = function (handlerLookup, on, off, adapter, prevProps, props, boundHandlers) {
    var prevEventKeys = Object.keys(prevProps).filter(isEventProp);
    var currEventKeys = Object.keys(props).filter(isEventProp);
    var removedKeys = prevEventKeys.filter(function (key) { return props[key] === undefined; });
    var addedKeys = currEventKeys.filter(function (key) { return prevProps[key] === undefined; });
    removedKeys.forEach(function (key) {
        // remove event handler
        var eventName = eventAttrToEventName(key);
        var wrappedHandler = boundHandlers[eventName];
        off(eventName, wrappedHandler);
        delete boundHandlers[eventName];
    });
    addedKeys.forEach(function (key) {
        var wrappedHandler = adapter(handlerLookup, key);
        var eventName = eventAttrToEventName(key);
        boundHandlers[eventName] = wrappedHandler;
        on(eventName, wrappedHandler);
    });
};
exports.configHandlers2 = configHandlers2;
var configHandlers = function (editor, prevProps, props, boundHandlers, lookup) {
    return (0, exports.configHandlers2)(lookup, editor.on.bind(editor), editor.off.bind(editor), 
    // eslint-disable-next-line @typescript-eslint/no-unsafe-argument
    function (handlerLookup, key) { return function (e) { var _a; return (_a = handlerLookup(key)) === null || _a === void 0 ? void 0 : _a(e, editor); }; }, prevProps, props, boundHandlers);
};
exports.configHandlers = configHandlers;
var unique = 0;
var uuid = function (prefix) {
    var time = Date.now();
    var random = Math.floor(Math.random() * 1000000000);
    unique++;
    return prefix + '_' + random + unique + String(time);
};
exports.uuid = uuid;
var isTextareaOrInput = function (element) {
    return element !== null && (element.tagName.toLowerCase() === 'textarea' || element.tagName.toLowerCase() === 'input');
};
exports.isTextareaOrInput = isTextareaOrInput;
var normalizePluginArray = function (plugins) {
    if (typeof plugins === 'undefined' || plugins === '') {
        return [];
    }
    return Array.isArray(plugins) ? plugins : plugins.split(' ');
};
// eslint-disable-next-line max-len
var mergePlugins = function (initPlugins, inputPlugins) { return normalizePluginArray(initPlugins).concat(normalizePluginArray(inputPlugins)); };
exports.mergePlugins = mergePlugins;
var isBeforeInputEventAvailable = function () { return window.InputEvent && typeof InputEvent.prototype.getTargetRanges === 'function'; };
exports.isBeforeInputEventAvailable = isBeforeInputEventAvailable;
var isInDoc = function (elem) {
    if (!('isConnected' in Node.prototype)) {
        // Fallback for IE and old Edge
        var current = elem;
        var parent_1 = elem.parentNode;
        while (parent_1 != null) {
            current = parent_1;
            parent_1 = current.parentNode;
        }
        return current === elem.ownerDocument;
    }
    return elem.isConnected;
};
exports.isInDoc = isInDoc;
var setMode = function (editor, mode) {
    if (editor !== undefined) {
        if (editor.mode != null && typeof editor.mode === 'object' && typeof editor.mode.set === 'function') {
            editor.mode.set(mode);
        }
        else { // support TinyMCE 4
            editor.setMode(mode);
        }
    }
};
exports.setMode = setMode;
var getTinymceOrError = function (view) {
    var tinymce = (0, TinyMCE_1.getTinymce)(view);
    if (!tinymce) {
        throw new Error('tinymce should have been loaded into global scope');
    }
    return tinymce;
};
exports.getTinymceOrError = getTinymceOrError;
var isDisabledOptionSupported = function (editor) { return editor.options && editor.options.isRegistered('disabled'); };
exports.isDisabledOptionSupported = isDisabledOptionSupported;
