import { z } from 'zod';
import { CustomPartSchema, DataPartSchema, DocumentDataSchema, MediaPartSchema, ReasoningPartSchema, TextPartSchema, ToolRequestPartSchema, ToolResponsePartSchema, } from './document';
export { CustomPartSchema, DataPartSchema, MediaPartSchema, TextPartSchema, ToolRequestPartSchema, ToolResponsePartSchema, };
export const OperationSchema = z.object({
    action: z.string().optional(),
    id: z.string(),
    done: z.boolean().optional(),
    output: z.any().optional(),
    error: z.object({ message: z.string() }).passthrough().optional(),
    metadata: z.record(z.string(), z.any()).optional(),
});
export const PartSchema = z.union([
    TextPartSchema,
    MediaPartSchema,
    ToolRequestPartSchema,
    ToolResponsePartSchema,
    DataPartSchema,
    CustomPartSchema,
    ReasoningPartSchema,
]);
export const RoleSchema = z.enum(['system', 'user', 'model', 'tool']);
export const MessageSchema = z.object({
    role: RoleSchema,
    content: z.array(PartSchema),
    metadata: z.record(z.unknown()).optional(),
});
export const ModelInfoSchema = z.object({
    versions: z.array(z.string()).optional(),
    label: z.string().optional(),
    configSchema: z.record(z.any()).optional(),
    supports: z
        .object({
        multiturn: z.boolean().optional(),
        media: z.boolean().optional(),
        tools: z.boolean().optional(),
        systemRole: z.boolean().optional(),
        output: z.array(z.string()).optional(),
        contentType: z.array(z.string()).optional(),
        context: z.boolean().optional(),
        constrained: z.enum(['none', 'all', 'no-tools']).optional(),
        toolChoice: z.boolean().optional(),
    })
        .optional(),
    stage: z
        .enum(['featured', 'stable', 'unstable', 'legacy', 'deprecated'])
        .optional(),
});
export const ToolDefinitionSchema = z.object({
    name: z.string(),
    description: z.string(),
    inputSchema: z
        .record(z.any())
        .describe('Valid JSON Schema representing the input of the tool.')
        .nullish(),
    outputSchema: z
        .record(z.any())
        .describe('Valid JSON Schema describing the output of the tool.')
        .nullish(),
    metadata: z
        .record(z.any())
        .describe('additional metadata for this tool definition')
        .optional(),
});
export const GenerationCommonConfigSchema = z.object({
    version: z.string().optional(),
    temperature: z.number().optional(),
    maxOutputTokens: z.number().optional(),
    topK: z.number().optional(),
    topP: z.number().optional(),
    stopSequences: z.array(z.string()).optional(),
});
export const OutputConfigSchema = z.object({
    format: z.string().optional(),
    schema: z.record(z.any()).optional(),
    constrained: z.boolean().optional(),
    contentType: z.string().optional(),
});
export const ModelRequestSchema = z.object({
    messages: z.array(MessageSchema),
    config: z.any().optional(),
    tools: z.array(ToolDefinitionSchema).optional(),
    toolChoice: z.enum(['auto', 'required', 'none']).optional(),
    output: OutputConfigSchema.optional(),
    docs: z.array(DocumentDataSchema).optional(),
});
export const GenerateRequestSchema = ModelRequestSchema.extend({
    candidates: z.number().optional(),
});
export const GenerationUsageSchema = z.object({
    inputTokens: z.number().optional(),
    outputTokens: z.number().optional(),
    totalTokens: z.number().optional(),
    inputCharacters: z.number().optional(),
    outputCharacters: z.number().optional(),
    inputImages: z.number().optional(),
    outputImages: z.number().optional(),
    inputVideos: z.number().optional(),
    outputVideos: z.number().optional(),
    inputAudioFiles: z.number().optional(),
    outputAudioFiles: z.number().optional(),
    custom: z.record(z.number()).optional(),
    thoughtsTokens: z.number().optional(),
    cachedContentTokens: z.number().optional(),
});
export const FinishReasonSchema = z.enum([
    'stop',
    'length',
    'blocked',
    'interrupted',
    'other',
    'unknown',
]);
export const CandidateSchema = z.object({
    index: z.number(),
    message: MessageSchema,
    usage: GenerationUsageSchema.optional(),
    finishReason: FinishReasonSchema,
    finishMessage: z.string().optional(),
    custom: z.unknown(),
});
export const CandidateErrorSchema = z.object({
    index: z.number(),
    code: z.enum(['blocked', 'other', 'unknown']),
    message: z.string().optional(),
});
export const ModelResponseSchema = z.object({
    message: MessageSchema.optional(),
    finishReason: FinishReasonSchema,
    finishMessage: z.string().optional(),
    latencyMs: z.number().optional(),
    usage: GenerationUsageSchema.optional(),
    custom: z.unknown(),
    raw: z.unknown(),
    request: GenerateRequestSchema.optional(),
    operation: OperationSchema.optional(),
});
export const GenerateResponseSchema = ModelResponseSchema.extend({
    candidates: z.array(CandidateSchema).optional(),
    finishReason: FinishReasonSchema.optional(),
});
export const ModelResponseChunkSchema = z.object({
    role: RoleSchema.optional(),
    index: z.number().optional(),
    content: z.array(PartSchema),
    custom: z.unknown().optional(),
    aggregated: z.boolean().optional(),
});
export const GenerateResponseChunkSchema = ModelResponseChunkSchema;
export const GenerateActionOutputConfig = z.object({
    format: z.string().optional(),
    contentType: z.string().optional(),
    instructions: z.union([z.boolean(), z.string()]).optional(),
    jsonSchema: z.any().optional(),
    constrained: z.boolean().optional(),
});
export const GenerateActionOptionsSchema = z.object({
    model: z.string(),
    docs: z.array(DocumentDataSchema).optional(),
    messages: z.array(MessageSchema),
    tools: z.array(z.string()).optional(),
    toolChoice: z.enum(['auto', 'required', 'none']).optional(),
    config: z.any().optional(),
    output: GenerateActionOutputConfig.optional(),
    resume: z
        .object({
        respond: z.array(ToolResponsePartSchema).optional(),
        restart: z.array(ToolRequestPartSchema).optional(),
        metadata: z.record(z.any()).optional(),
    })
        .optional(),
    returnToolRequests: z.boolean().optional(),
    maxTurns: z.number().optional(),
});
//# sourceMappingURL=model.js.map