import { extendZodWithOpenApi } from '@asteasolutions/zod-to-openapi';
import { z } from 'zod';
extendZodWithOpenApi(z);
export const SingularAnySchema = z
    .union([z.string(), z.number(), z.bigint(), z.boolean(), z.object({})])
    .openapi('SingularAny');
export const CustomAnySchema = z
    .union([SingularAnySchema, z.array(SingularAnySchema)])
    .openapi('CustomAny');
export const JSONSchema7Schema = z
    .object({})
    .describe('A JSON Schema Draft 7 (http://json-schema.org/draft-07/schema) object.')
    .nullish()
    .openapi('JSONSchema7');
export const ActionSchema = z
    .object({
    key: z.string().describe('Action key consisting of action type and ID.'),
    name: z.string().describe('Action name.'),
    description: z
        .string()
        .describe('A description of what the action does.')
        .nullish(),
    inputSchema: JSONSchema7Schema,
    outputSchema: JSONSchema7Schema,
    metadata: z
        .record(z.string(), CustomAnySchema)
        .describe('Metadata about the action (e.g. supported model features).')
        .nullish(),
})
    .openapi('Action');
export const RunActionResponseSchema = z.object({
    result: z.unknown().optional(),
    telemetry: z
        .object({
        traceId: z.string().optional(),
    })
        .optional(),
    genkitVersion: z.string().optional(),
});
//# sourceMappingURL=action.js.map