"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunActionResponseSchema = exports.ActionSchema = exports.JSONSchema7Schema = exports.CustomAnySchema = exports.SingularAnySchema = void 0;
const zod_to_openapi_1 = require("@asteasolutions/zod-to-openapi");
const zod_1 = require("zod");
(0, zod_to_openapi_1.extendZodWithOpenApi)(zod_1.z);
exports.SingularAnySchema = zod_1.z
    .union([zod_1.z.string(), zod_1.z.number(), zod_1.z.bigint(), zod_1.z.boolean(), zod_1.z.object({})])
    .openapi('SingularAny');
exports.CustomAnySchema = zod_1.z
    .union([exports.SingularAnySchema, zod_1.z.array(exports.SingularAnySchema)])
    .openapi('CustomAny');
exports.JSONSchema7Schema = zod_1.z
    .object({})
    .describe('A JSON Schema Draft 7 (http://json-schema.org/draft-07/schema) object.')
    .nullish()
    .openapi('JSONSchema7');
exports.ActionSchema = zod_1.z
    .object({
    key: zod_1.z.string().describe('Action key consisting of action type and ID.'),
    name: zod_1.z.string().describe('Action name.'),
    description: zod_1.z
        .string()
        .describe('A description of what the action does.')
        .nullish(),
    inputSchema: exports.JSONSchema7Schema,
    outputSchema: exports.JSONSchema7Schema,
    metadata: zod_1.z
        .record(zod_1.z.string(), exports.CustomAnySchema)
        .describe('Metadata about the action (e.g. supported model features).')
        .nullish(),
})
    .openapi('Action');
exports.RunActionResponseSchema = zod_1.z.object({
    result: zod_1.z.unknown().optional(),
    telemetry: zod_1.z
        .object({
        traceId: zod_1.z.string().optional(),
    })
        .optional(),
    genkitVersion: zod_1.z.string().optional(),
});
//# sourceMappingURL=action.js.map